"""
Read Massive Drill Holes Data
=============================

This example shows how to read a big database of drill holes logs.
"""
import geoassistant

bbdd_dir = "../resources/"

collar_path = bbdd_dir + '01_COLLAR.csv'
survey_path = bbdd_dir + '02_SURVEY.csv'
geotech_log_path = bbdd_dir + '06_GEOTECHNICAL.csv'

cc = geoassistant.readCollarsCsvFile(filepath=collar_path,
                                          x_key="E_UTM_WGS8", y_key="N_UTM_WGS8", z_key="Elevation",
                                          id_key="Hole_ID")
print(cc)

sc = geoassistant.readSurveysCsvFile(filepath=survey_path, id_key="HoleID",
                                          dip_key="DIP", azimuth_key="AZIMUT", depth_key="LENGTH")
print(sc)

drillholes = geoassistant.createDrillholesFromCollarsAndSurveys(collars=cc, surveys=sc)
print(drillholes)


# %%
# At this point, GeoAssistant has created all the drill holes objects with their corresponding positioning.
# Now it's time to match these objects with the mapping logs.
#
# Each row of a mapping log (.csv or .xlsx file) represents an **Interval** of a drill hole, defined by From/To.
# GeoAssistant can read these files and assignt these Intervals to their corresponding **DrillHole** objects:

intervals = geoassistant.readIntervalsCsvFile(filepath=geotech_log_path,
                                              id_key='Hole_ID', from_key='From_m', to_key='To_m',
                                              drillholes=drillholes)
print(intervals)
# %%
# Note that **drillholes** is an optional argument here. This means that Intervals can also exist without being
# related to a **DrillholesCollection**.


# drillholes.addIntervalsCollection(intervals=intervals)

# drillholes.createCorrelationPlot(x_parameter="FF", y_parameter="RQD")

# drillholes.getPolylines().plot3d(filepath="tets.png")
#
# import matplotlib.pyplot as plt
# import matplotlib.image as mpimg
#
# img = mpimg.imread("tets.png")
# plt.imshow(img)
# plt.axis("off")
# plt.show()
